<?php $__env->startSection('page_title', __('label.package')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.package')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.package')); ?></li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="<?php echo e(route('package.create')); ?>" class="btn btn-default mw-120" style="margin-top: -14px;"><?php echo e(__('label.add_package')); ?></a>
                </div>
            </div>

            <!-- Search -->
            <div class="page-search mb-3">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                            <i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i>
                        </span>
                    </div>
                    <input type="text" id="input_search" class="form-control" placeholder="<?php echo e(__('label.search_package')); ?>" aria-label="Search" aria-describedby="basic-addon1">
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-striped package-table text-center table-bordered">
                    <thead>
                        <tr style="background: #F9FAFF;">
                            <th><?php echo e(__('label.#')); ?></th>
                            <th><?php echo e(__('label.name')); ?></th>
                            <th><?php echo e(__('label.price')); ?></th>
                            <th><?php echo e(__('label.duration')); ?></th>
                            <th><?php echo e(__('label.action')); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>

        // Sidebar Scroll Down
        sidebar_down($(document).height());

        $(document).ready(function() {
            var table = $('.package-table').DataTable({
                dom: "<'top'f>rt<'row'<'col-2'i><'col-1'l><'col-9'p>>",
                searching: false,
                responsive: true,
                autoWidth: false,
                processing: true,
                serverSide: true,
                lengthMenu: [[10, 100, 500, -1], [10, 100, 500, "All"]],
                language: {
                    paginate: {
                        previous: "<i class='fa-solid fa-chevron-left'></i>",
                        next: "<i class='fa-solid fa-chevron-right'></i>"
                    }
                },
                ajax: {
                    url: "<?php echo e(route('package.index')); ?>",
                    data: function(d) {
                        d.input_search = $('#input_search').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'price',
                        name: 'price'
                    },
                    {
                        data: 'time',
                        name: 'time',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row, meta) {
                            if (row.time && row.type) {
                                return row.time + " " + row.type;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
            });

            $('#input_search').keyup(function() {
                table.draw();
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/admin/package/index.blade.php ENDPATH**/ ?>