
<?php $__env->startSection('page_title', __('label.profile')); ?>

<?php $__env->startSection('content'); ?>
	<?php echo $__env->make('producer.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<div class="right-content">
		<?php echo $__env->make('producer.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm"><?php echo e(__('label.profile')); ?></h1>

			<div class="border-bottom row mb-3">
				<div class="col-sm-12">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="<?php echo e(route('producer.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
						<li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.profile')); ?></li>
					</ol>
				</div>
			</div>

            <div class="card custom-border-card">
                <form id="profile" enctype="multipart/form-data">
                    <input type="hidden" name="id" value="<?php if($data): ?><?php echo e($data->id); ?><?php endif; ?>">
                    <div class="form-row">
                        <div class="col-md-9">
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.user_name')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="user_name" value="<?php if($data): ?><?php echo e($data->user_name); ?><?php endif; ?>" class="form-control" placeholder="<?php echo e(__('label.enter_user_name')); ?>" autofocus>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.full_name')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="full_name" value="<?php if($data): ?><?php echo e($data->full_name); ?><?php endif; ?>" class="form-control" placeholder="<?php echo e(__('label.enter_full_name')); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.email')); ?><span class="text-danger">*</span></label>
                                        <input type="email" name="email" value="<?php if($data): ?><?php echo e($data->email); ?><?php endif; ?>" class="form-control" placeholder="<?php echo e(__('label.enter_email')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.mobile_number')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="mobile_number" value="<?php if($data): ?><?php echo e($data->mobile_number); ?><?php endif; ?>" class="form-control" placeholder="<?php echo e(__('label.enter_mobile_number')); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group ml-5">
                                <label><?php echo e(__('label.image')); ?><span class="text-danger">*</span></label>
                                <div class="avatar-upload">
                                    <div class="avatar-edit">
                                        <input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUpload" title="<?php echo e(__('label.select_file')); ?>"></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <img src="<?php echo e($data->image); ?>" alt="upload_img.png" id="imagePreview">
                                    </div>
                                </div>
                                <input type="hidden" name="old_image" value="<?php if($data): ?><?php echo e($data->image); ?><?php endif; ?>">
                                <label class="mt-3 text-gray"><?php echo e(__('label.maximum_size_2mb')); ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="update_profile()"><?php echo e(__('label.update')); ?></button>
                        <input type="hidden" name="_method" value="PATCH">
                    </div>
                </form>
            </div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
	<script>
		function update_profile(){
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#profile")[0]);

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    enctype: 'multipart/form-data',
                    type: 'POST',
                    url: '<?php echo e(route("pprofile.update", [$data->id])); ?>',
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success:function(resp){
                        $("#dvloader").hide();
                        get_responce_message(resp, 'profile', '<?php echo e(route("pprofile.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
		}
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('producer.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/producer/profile/index.blade.php ENDPATH**/ ?>