<?php $__env->startSection('page_title', __('label.types')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.types')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.types')); ?></li>
                    </ol>
                </div>
            </div>

            <!-- Add Type -->
            <div class="card custom-border-card mt-3">
                <h5 class="card-header"><?php echo e(__('label.add_type')); ?></h5>
                <div class="card-body">
                    <form id="type" enctype="multipart/form-data">
                        <input type="hidden" name="id" value="">
                        <div class="form-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo e(__('label.name')); ?><span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" placeholder="<?php echo e(__('label.enter_name')); ?>" autofocus>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo e(__('label.type')); ?><span class="text-danger">*</span></label>
                                    <select name="type" class="form-control">
                                        <option value=""><?php echo e(__('label.select_type')); ?></option>
                                        <option value="1"><?php echo e(__('label.video')); ?></option>
                                        <option value="2"><?php echo e(__('label.show')); ?></option>
                                        <option value="5"><?php echo e(__('label.upcoming')); ?></option>
                                        <option value="6"><?php echo e(__('label.channel')); ?></option>
                                        <option value="7"><?php echo e(__('label.kids')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120" onclick="save_type()"><?php echo e(__('label.save')); ?></button>
                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        </div>
                    </form>
                </div>
            </div>

            <!-- Search && Table -->
            <div class="card custom-border-card mt-3">
                <div class="page-search mb-3">
                    <div class="input-group" title="<?php echo e(__('label.search')); ?>">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i></span>
                        </div>
                        <input type="text" id="input_search" class="form-control" placeholder="<?php echo e(__('label.search_type')); ?>" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                    <div class="sorting">
                        <label><?php echo e(__('label.sort_by')); ?></label>
                        <select class="form-control" name="input_type" id="input_type">
                            <option value="0" selected><?php echo e(__('label.all_type')); ?></option>
                            <option value="1"><?php echo e(__('label.video')); ?></option>
                            <option value="2"><?php echo e(__('label.show')); ?></option>
                            <option value="5"><?php echo e(__('label.upcoming')); ?></option>
                            <option value="6"><?php echo e(__('label.channel')); ?></option>
                            <option value="7"><?php echo e(__('label.kids')); ?></option>
                        </select>
                    </div>
                </div>

                <div class="table-responsive table">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr style="background: #F9FAFF;">
                                <th><?php echo e(__('label.#')); ?></th>
                                <th><?php echo e(__('label.name')); ?></th>
                                <th><?php echo e(__('label.type')); ?></th>
                                <th><?php echo e(__('label.status')); ?></th>
                                <th><?php echo e(__('label.action')); ?></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>

            <!-- Edit Model -->
            <div class="modal fade" id="EditModel" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('label.edit_type')); ?></h5>
                            <button type="button" class="close text-dark" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="update_type" enctype="multipart/form-data">
                            <div class="modal-body">
                                <input type="hidden" name="id" id="edit_id">
                                <div class="form-row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label><?php echo e(__('label.name')); ?><span class="text-danger">*</span></label>
                                            <input type="text" name="name" id="edit_name" class="form-control" placeholder="<?php echo e(__('label.enter_name')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label><?php echo e(__('label.type')); ?><span class="text-danger">*</span></label>
                                            <select class="form-control" name="type" id="edit_type">
                                                <option value=""><?php echo e(__('label.select_type')); ?></option>
                                                <option value="1"><?php echo e(__('label.video')); ?></option>
                                                <option value="2"><?php echo e(__('label.show')); ?></option>
                                                <option value="5"><?php echo e(__('label.upcoming')); ?></option>
                                                <option value="6"><?php echo e(__('label.channel')); ?></option>
                                                <option value="7"><?php echo e(__('label.kids')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default mw-120" onclick="update_type()"><?php echo e(__('label.update')); ?></button>
                                <button type="button" class="btn btn-cancel mw-120" data-dismiss="modal"><?php echo e(__('label.close')); ?></button>
                                <input type="hidden" name="_method" value="PATCH">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                dom: "<'top'f>rt<'row'<'col-2'i><'col-1'l><'col-9'p>>",
                searching: false,
                responsive: true,
                autoWidth: false,
                processing: true,
                serverSide: true,
                lengthMenu: [
                    [10, 100, 500, -1],
                    [10, 100, 500, "All"]
                ],
                language: {
                    paginate: {
                        previous: "<i class='fa-solid fa-chevron-left'></i>",
                        next: "<i class='fa-solid fa-chevron-right'></i>"
                    }
                },
                ajax: {
                    url: "<?php echo e(route('type.index')); ?>",
                    data: function(d) {
                        d.input_type = $('#input_type').val();
                        d.input_search = $('#input_search').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'name',
                        name: 'name',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'type',
                        name: 'type',
                        render: function(data, type, full, meta) {
                            if (data == 1) {
                                return "<?php echo e(__('label.video')); ?>";
                            } else if (data == 2) {
                                return "<?php echo e(__('label.show')); ?>";
                            } else if (data == 5) {
                                return "<?php echo e(__('label.upcoming')); ?>";
                            } else if (data == 6) {
                                return "<?php echo e(__('label.channel')); ?>";
                            } else if (data == 7) {
                                return "<?php echo e(__('label.kids')); ?>";
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
            });

            $('#input_type').change(function() {
                table.draw();
            });
            $('#input_search').keyup(function() {
                table.draw();
            });
        });

        function save_type() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if (Check_Admin == 1) {

                $("#dvloader").show();
                var formData = new FormData($("#type")[0]);
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("type.store")); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'type', '<?php echo e(route("type.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        }

        function change_status(id, status) {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if (Check_Admin == 1) {

                $("#dvloader").show();
                var url = "<?php echo e(route('type.show', '')); ?>" + "/" + id;
                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: id,
                    success: function(resp) {
                        $("#dvloader").hide();
                        if (resp.status == 200) {
                            if (resp.Status_Code == 1) {

                                $('#' + id).text('<?php echo e(__("label.show")); ?>');
                                $('#' + id).css({
                                    "background": "#058f00",
                                    "font-weight": "bold",
                                    "color": "white",
                                    "border": "none",
                                    "outline": "none",
                                    "padding": "5px 15px",
                                    "border-radius": "5px",
                                    "cursor": "pointer",
                                });
                            } else {

                                $('#' + id).text('<?php echo e(__("label.hide")); ?>');
                                $('#' + id).css({
                                    "background": "#e3000b",
                                    "color": "white",
                                    "border": "none",
                                    "outline": "none",
                                    "padding": "5px 20px",
                                    "border-radius": "5px",
                                    "cursor": "pointer",
                                });
                            }
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        };

        $(document).on("click", ".edit_type", function() {
            var id = $(this).data('id');
            var name = $(this).data('name');
            var type = $(this).data('type');

            $(".modal-body #edit_id").val(id);
            $(".modal-body #edit_name").val(name);
            $(".modal-body #edit_type").val(type).attr("selected", "selected");
        });

        function update_type() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if (Check_Admin == 1) {

                $("#dvloader").show();
                var formData = new FormData($("#update_type")[0]);
                var Edit_Id = $("#edit_id").val();

                var url = '<?php echo e(route("type.update", ":id")); ?>';
                url = url.replace(':id', Edit_Id);

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    enctype: 'multipart/form-data',
                    type: 'POST',
                    url: url,
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            $('#EditModel').modal('toggle');
                        }

                        get_responce_message(resp, 'update_type', '<?php echo e(route("type.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/admin/type/index.blade.php ENDPATH**/ ?>