<?php $__env->startSection('page_title', __('label.edit_package')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.edit_package')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('package.index')); ?>"><?php echo e(__('label.package')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.edit_package')); ?></li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="<?php echo e(route('package.index')); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('label.package_list')); ?></a>
                </div>
            </div>

            <div class="card custom-border-card mt-3">
                <form enctype="multipart/form-data" id="package_update">
                    <input type="hidden" value="<?php echo e($data->id); ?>" name="id">
                    <div class="form-row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.name')); ?><span class="text-danger">*</span></label>
                                <input name="name" type="text" value="<?php echo e($data->name); ?>" class="form-control" placeholder="<?php echo e(__('label.enter_package_name')); ?>" autofocus>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.price')); ?><span class="text-danger">*</span></label>
                                <input name="price" type="number" value="<?php echo e($data->price); ?>" class="form-control" placeholder="<?php echo e(__('label.enter_package_price')); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.package_time')); ?><span class="text-danger">*</span></label>
                                <select class="form-control" id="validity_type" name="type">
                                    <option value=""><?php echo e(__('label.select_type')); ?></option>
                                    <option value="Month" <?php echo e($data->type == 'Month' ? 'selected' : ''); ?>><?php echo e(__('label.month')); ?></option>
                                    <option value="Year" <?php echo e($data->type == 'Year' ? 'selected' : ''); ?>><?php echo e(__('label.year')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3 mt-3">
                            <div class="form-group">
                                <select class="form-control time mt-3" id="time" name="time">
                                    <option value=""><?php echo e(__('label.select_number')); ?></option>
                                    <?php for($i=1; $i<=12; $i++): ?>
                                        <option value="<?php echo e($i); ?>" <?php echo e($data->time == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.watch_on_tv')); ?><span class="text-danger">*</span></label>
                                <div class="radio-group">
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="watch_on_laptop_tv" id="watch_on_laptop_tv_yes" class="custom-control-input" value="1" <?php echo e($data->watch_on_laptop_tv == 1 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="watch_on_laptop_tv_yes"><?php echo e(__('label.yes')); ?></label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="watch_on_laptop_tv" id="watch_on_laptop_tv_no" class="custom-control-input" value="0" <?php echo e($data->watch_on_laptop_tv == 0 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="watch_on_laptop_tv_no"><?php echo e(__('label.no')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.ads_free_content')); ?><span class="text-danger">*</span></label>
                                <div class="radio-group">
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="ads_free_content" id="ads_free_content_yes" class="custom-control-input" value="1" <?php echo e($data->ads_free_content == 1 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="ads_free_content_yes"><?php echo e(__('label.yes')); ?></label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="ads_free_content" id="ads_free_content_no" class="custom-control-input" value="0" <?php echo e($data->ads_free_content == 0 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="ads_free_content_no"><?php echo e(__('label.no')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.no_of_device_sync')); ?><span class="text-danger">*</span></label>
                                <input name="no_of_device_sync" type="number" value="<?php echo e($data->no_of_device_sync); ?>"  min="1" class="form-control" placeholder="<?php echo e(__('label.enter_no_of_device_sync')); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-3 mt-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.android_product_package')); ?><span class="text-danger">*</span></label>
                                <input name="android_product_package" value="<?php echo e($data->android_product_package); ?>" type="text" class="form-control" placeholder="<?php echo e(__('label.enter_android_product_package')); ?>">
                            </div>
                        </div>
                        <div class="col-md-3 mt-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.ios_product_package')); ?><span class="text-danger">*</span></label>
                                <input name="ios_product_package" value="<?php echo e($data->ios_product_package); ?>" type="text" class="form-control" placeholder="<?php echo e(__('label.enter_ios_product_package')); ?>">
                            </div>
                        </div>
                        <div class="col-md-3 mt-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.web_product_package')); ?><span class="text-danger">*</span></label>
                                <input name="web_product_package" value="<?php echo e($data->web_product_package); ?>" type="text" class="form-control" placeholder="<?php echo e(__('label.enter_web_product_package')); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="border-top pt-3 text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="package_update()"><?php echo e(__('label.save')); ?></button>
                        <a href="<?php echo e(route('package.index')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('label.cancel')); ?></a>
                        <input type="hidden" name="_method" value="PATCH">
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>

        // Sidebar Scroll Down
        sidebar_down($(document).height());

        function package_update() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                var formData = new FormData($("#package_update")[0]);
                $("#dvloader").show();

                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("package.update", [$data->id])); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'package_update', '<?php echo e(route("package.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        }

        $(document).ready(function() {
            var validity_type = "<?php echo $data->type; ?>";
            if (validity_type == "Month") {
                for (let i = 13; i <= 12; i++) {
                    $(".time option[value=" + i + "]").hide();
                }
            } else if (validity_type == "Year") {
                for (let i = 2; i <= 12; i++) {
                    $(".time option[value=" + i + "]").hide();
                }
            } else {
                $('.time').hide();
            }
        });

        $('#validity_type').on('click', function() {
            $('.time').show();
            var type = $("#validity_type").val()

            for (let i = 1; i <= 12; i++) {
                $(".time option[value=" + i + "]").show();
                $(".time option[value=" + i + "]").attr("selected", false);
            }

            if (type == "Month") {
                for (let i = 13; i <= 12; i++) {
                    $(".time option[value=" + i + "]").hide();
                }
            } else if (type == "Year") {
                for (let i = 2; i <= 12; i++) {
                    $(".time option[value=" + i + "]").hide();
                }
            } else {
                $('.time').hide();
            }
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/admin/package/edit.blade.php ENDPATH**/ ?>